      subroutine derivSch(va,y,n,dyt)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Compute the time derivative of time-dependent Schrodinger
c         in interaction picture for Schrodinger Eq.
c     equation: dyt=dy/dt=-i*H*y/hbar=A*y (hbar=1)
c     Tremblay et. al. Journal of Chemical Physics v121 11535 (2004).
ccccccccccccccccccccc INPUT PARAMETERS ccccccccccccccccccccccccccccccc
c.
c.    1) function y(t) is the wave function.
c.    2) n is the dimension of vector y(t)
c.    3) va is n*n complex A matirx in interaction picture for
c.       Schrodinger Eq. where A is defiend as A=-iv/hbar in
c.       Tremblay 2004.. It is function of time.
ccccccccccccccccccccc OUTPUT PARAMETERS ccccccccccccccccccccccccccccccc
c.    1) dyt is dy/dt=-i*H(t)*y(t)=A(t)*y(t)=-k_1/dt at time t.
ccccccccccccccccccccccccccccccccccc
cc    07/09/2015
c     fix a bug in matrix multiplied vector:
c     dyt(i)=dyt(i)+va(i,j)*y(i)

      implicit none
      integer n,i,j
      complex*16 dyt(n),va(n,n),y(n)

c.    Intiallization of
      do i=1,n
         dyt(i)=DCMPLX(0.0d0,0.0d0)
      end do

      do i=1,n
         do j=1,n
c.             dyt(i)=dyt(i)+va(i,j)*y(i) This is wrong!
            dyt(i)=dyt(i)+va(i,j)*y(j)
         end do
      end do

      return

      end
