      subroutine cAip(v,va,n)
c.    Convert the n*n real symmentric potential matrix v into
c.       n*n complex A matirx in interaction picture for Schrodinger Eq.
c.       where A is defiend as A=-iv/hbar in Tremblay 2004.
ccccccccccccccccccccc  INPUT cccccccccccccccccccc

ccccccccccccccccccccc  OUTPUT cccccccccccccccccccc
c     1) va is the n*n complex A matirx
          implicit none
          integer n,m,i,j
          double precision vmax,vmin, deltaVh
          double precision v(n,n),inter(n,n)
          double precision D(n),eigv(n,n)
          complex*16 EYE
          complex*16 va(n,n)
          external JACOBI1,eigsrt
ccccccccccccccccccccccccccccccccccccccccccccccccccccc
          inter=v
          call JACOBI1(inter,n,n,D,eigv,m)
          call eigsrt(D,eigv,n,n)
          vmax=D(1)
          vmin=D(n)
          deltaVh=(vmax-vmin)/2.0d0
c.          print *, 'eigenvalue is', vmax,vmin
c.....EYE is double complex number i
          EYE=DCMPLX(0.D0,1.D0)
          do i=1,n
             do j=1,n
                if (i.eq.j) then
                   va(i,j)=-EYE*DCMPLX(v(i,j)-vmin-deltaVh,0.0d0)
                else
                   va(i,j)=-EYE*DCMPLX(v(i,j),0.0d0)
                end if
c.                print *, 'the Hamiltonian is',i,j,va(i,j)
             end do
          end do
c      print *, 'va is', va(1,1),va(1,2),va(2,1)

          return
      end
