      subroutine rk4vec_fix(y,dydt,n,time,deltatime,psifstore,
     * vha,vfa)

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Preconditioned fixed step size Runge-Kutta method
c     for soving the time-dependent Schrodinger equation
c     Tremblay et. al. Journal of Chemical Physics v121 11535 (2004).
ccccccccccccccccccccc INPUT PARAMETERS ccccccccccccccccccccccccccccccc
c.....1) v is the real double precision symmentric Hamiltonian
c.....(exclude kinetic energy).
c.....1) y is the initial wave function psi(t).
c.....2) dydx is the initial slope of the psi(t), which is k_1/deltat.
c        One can get it by calling derivSch
c.....3) np is the dimension of the Hamiltonian.
c.....It is also the channel number.
c.....4) deltatime is the length of each time step.
c.    5) vha is n*n complex A matirx in interaction picture
c.       for Schrodinger Eq at time time+dt/2.
c.       where A is defiend as A=-i*H_I/hbar in Tremblay 2004.
c.    6) ) vfa is n*n complex A matirx in interaction picture
c.       for Schrodinger Eq at time time+dt.
c.       where A is defiend as A=-i*H_I/hbar in Tremblay 2004.
c.
ccccccccccccccccccccc OUTPUT PARAMETERS cccccccccccccccccccccccccccccc
c.....1) psifstore is the final wave function after the propagation.
c.....It will be the psii of the next iteration.
c.....2) In the end of iteration, y is replaced for next iteration.

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c.    07/09/2015
c.    1) Fix the problem of memory leaking in which the call of
c.    derivSch(vf,yt,n,dyt) is missed as derivSch(vf,yt,dyt)
c.    2) check the output potential matrix v at each step
c.       with known results. subroutine pomt works well at every step.
c.    3) check -I*H_I and subroutine cAip seems not bad.
c.    4) finally find bug in subroutine derivSch!

      implicit none
      integer i,n
      double precision deltatime,hh,h6,time,timeh
      double precision v(n,n),psifstore(2*n)
      complex*16 y(n),yt(n),dydt(n),dyt(n),dym(n),yout(n)
      complex*16 vha(n,n),vfa(n,n)
      external derivSch

c.....hh is deltat/2 in eq(4) in Tremblay
c.....h6 is deltat/6 in eq(7) in Tremblay
c.....timeh(alf) is the time at the mid-point
      hh=0.5d0*deltatime
      h6=deltatime/6.0d0
c      timeh=time+hh

c.    first step: from k_1/deltat, getting k_2 and psi_2=psi+k_1/2
c.    here dydx=k_1/deltat=A(t)*psi(t) in Tremblay
c....      dydx is the derivative at time t
c.....yt is psi(t)+k_1/2 in eq(4)
      do i=1,n
         yt(i)=y(i)+hh*dydt(i)
      enddo
c.      print *, 'The first step', yt(1)
c.....second step
c.....compute deravative dyt=k_2/deltat=A(t+deltat/2)*yt in eq(4)
c.....         at timeh=t+deltat/2
c.....derivs(timeh,yt,dyt) give dyt=k_2/deltat
c.....now yt is changed to psi(t)+k_2/2 in eq(5)
      call derivSch(vha,yt,n,dyt)
c.      print *,'the vh in 1 step is', vh(1,1),vh(2,2),vh(1,2)
      do i=1,n
         yt(i)=y(i)+hh*dyt(i)
c.         print *, 'In the 1st step in rk4,yt is',i, yt(i)
c.         print *, 'In the 1st step in rk4,dyt is',i, dyt(i)
      enddo
c.      print *, 'The second step', yt(1)
c     Third step
c.....compute dym=k_3/deltat, yt=psi(t)+k_3
      call derivSch(vha,yt,n,dym)
c      print *,'the vh in 2 step is', vh(1,1),vh(2,2),vh(1,2)
      do i=1,n
         yt(i)=y(i)+deltatime*dym(i)
c         print *, 'In the 2rd step in rk4',i, yt(i)
c.    now dym=(k_2+k_3)/deltat
         dym(i)=dyt(i)+dym(i)
      enddo
c.      print *, 'The third step', yt(1)
c.    fourth step: from k_3 to k_4
c.....now dyt=k_4/deltat,
      call derivSch(vfa,yt,n,dyt)
      do i=1,n
         yout(i)=y(i)+h6*(dydt(i)+dyt(i)+2.0d0*dym(i))
         psifstore(i)=dreal(yout(i))
         psifstore(i+n)=dimag(yout(i))
c.    Overwrite initial y with final y for next iteration
         y(i)=yout(i)
      enddo
c.      print *, 'The four step', yout(1),yout(2),yout(3)

      return

      END
