c.    In collision problem, given the impact parameter b and initial
c.    velocity v_0, we construct the potential matrix at time t.

      subroutine pomt(b,v0,time,n,ndat,r,pot,pot2,mau,v)
c.    This subroutine must follow the call of subroutine potn.f.
ccccccccccccccccccccc  INPUT cccccccccccccccccccc
c.    1) b = impact parameter (a.u.)
c.    2) v0 = initial velocity (a.u.)
c.    3) time: variable time instance
c.    4) n  = size of state basis (same as np)
c     5) ndat = length of potential data for each matrix element
c.....6) pot = entire final potential array
c     7) pot2 = spline parameters for potential
c     8) mau=mu*uau: reduced mass (au)
ccccccccccccccccccccc  OUTPUT cccccccccccccccccccc
c     1) v is the n*n double precision potential matrix at time t
ccccccccccccccccccccccccccccccccccccccccccccccccccc

      implicit none
      integer n,i,k,jj,ndat
      double precision b,v0,time,mau,x,y
      double precision r(ndat),pot(ndat,n,n),pot2(ndat,n,n),v(n,n)
      double precision pott(ndat),pott2(ndat)
      external splint
c     Get distance x for a time t with given b and v0
      x=dsqrt(b**2+v0**2*time**2)
c.    loop over matrix indexes i and k
       do i=1,n
         do k=1,n
           do jj=1,ndat
             pott(jj)=pot(jj,i,k)
             pott2(jj)=pot2(jj,i,k)
c.             print *, 'pott is', i,k,jj,pott(jj)
           end do
           call splint(r,pott,pott2,ndat,x,y)
           v(i,k)=y
c.           print *, 'v(i,k) is', i,k,x,y
c       add centrifugal potential
           if(i.eq.k) v(i,k)=v(i,k)+ (b/x)**2*mau*v0**2/2.0d0
          end do
      end do

      return
      end
