      subroutine chebyshev3(v,psii,np,deltatime,psifstore)
ccccccccccccccccccccc INPUT PARAMETERS ccccccccccccccccccccccccccccccc
c.....1) v is the real double precision symmentric Hamiltonian
c.....(exclude kinetic energy).
c.....2) psii is the initial wave function psi(0) in Kosloff1991.
c.....3) np is the dimension of the Hamiltonian.
c.....It is also the channel number.
c.....4) deltatime is the length of each time step.
ccccccccccccccccccccc OUTPUT PARAMETERS cccccccccccccccccccccccccccccc
c.....psifstore is the final wave function after the propagation.
c.....It will be the psii of the next iteration.

c.....phin is the phi_n in Kosloff 1991, phin=PHI_n(-ivc)*psii
c.....vc is the normalized complex Hamiltonian. It is H_norm in Kosloff.
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c.    v1.3 2015/06/30
c     Fix the following problems
c     1) for JACOBI1(psii,np,np,D,eigv,m), the value of agument psii
c        change to block matrix after the call thus if one want to use
c        the value of psii for later calculation, need to replace
c        an intermediate augument with psii
c     2) the dimension of  input psii of chebyshev3 is np, need to
c        convert the 2*np dim to np dim (using subrutine VrtoVc.f.)
c     v1.4 2015/07/01
c.    Fix the problem that one should overwrite initial psi with
c.    final psi to interate. (look at cn_prop_noke1.f)

      implicit none
      integer np,m,N,nterms,i,j,k
      double precision deltatime,vmax,vmin,deltaV,ESC,E0,ALPHA
      double precision a0alpha,a1alpha,aalpha
      double precision BESSJ0,BESSJ1,BESSJ
      double precision v(np,np),D(np),eigv(np,np),CBESS(0:255)
      double precision vnorm(np,np),inter(np,np),psifstore(2*np)
      complex*16 EYE,CPF,trynum
      COMPLEX*16 psii(np),phif(np),vc(np,np),psif(np)
      complex*16 phir(np), phic(np),temv(np),temv1(np)
      external JACOBI1,eigsrt,BESSJ0,BESSJ1,BESSJ,cmmulv,che_renorm
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccc PRECALCULATE USEFUL QUANTITIES cccccccccccccc
c.....Compute the E_max=vmax and E_min=vmin of the instantanous
c.....Hamiltonian v. It is real double type.
c.....After the jacobi1, the first argument is destroied and
c.    turns to blocked, so we need a "inter" substituting into jacobi1.
c.    I made mistake at the begnning and the Hamiltonian v is changed
c.    after the call of jacobi1!
      inter=v
      call JACOBI1(inter,np,np,D,eigv,m)
      call eigsrt(D,eigv,np,np)
      vmax=D(1)
      vmin=D(np)
c      print *, 'Vmax is', vmax

c.....Conversion factors and constants.
c.....CZERO is double complex number 0
c     CZERO=DCMPLX(0.D0,0.D0)
c.....EYE is double complex number i
      EYE=DCMPLX(0.D0,1.D0)
c.....DELTAV is deltaE_grid in Eq.(4.2) Kosloff1991.
      deltaV=vmax-vmin

c.....E0 is the zero of energy for energy scaling (i.e. the centre
c.....    of the range).
c.....ESC is the energy scaling parameter ( so that scaled energy
c.... lies between -1 and 1).
c.....It is deltaE_grid/2 in Eq.(4.2) Kosloff1991.
      ESC=0.5D0*DELTAV
      E0= VMIN + ESC

c.....Calculate phase factor in Eq(4.4) Kosloff.
      CPF=CDEXP(-EYE*E0*deltatime)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c.....Pre-calculate Bessel functions.
c.....Calculate argument.ALPHA is the argument in the Bessel functions,
c.....which is deltaE_grid*t/2 in Eq.(4.3) Kosloff1991.
c.....It is double float type, DTIME=TTIME/DFLOAT(NRECT)
      ALPHA=ESC*deltatime
c..... print *, 'alpha is',ALPHA
c.....Calculate NTERMS : number of terms in the Chebychev polynomial
c.....expansion. Error tolerance is 1.0D-14 in Kosloff1991.
c.....CBESS(0) is the first kind of Beseel function J_(0)(alpha)
c.....a_0,a_1 are defined in Eq(4.4) Kosloff.
c.....a_0=J_0(alpha)
c.....a_1=2.*J_1(alpha)
      CBESS(0)=BESSJ0(ALPHA)
      CBESS(1)=BESSJ1(ALPHA)
cccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccc
c      N=1
c100   N=N+1
c      IF(N.GT.255) THEN
c         WRITE(6,*)' NTERMS greater than 256 '
c         WRITE(6,*)' Dimensions of CBESS(N) must be increased '
c         STOP
c      END IF
c      CBESS(N)=bessj(N,ALPHA)
c      IF(DABS(CBESS(N)).GT.1.0D-10) GO TO 100
c      nterms=N
c      print *,nterms
cccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccc
      do N=2,5
         CBESS(N)=bessj(N,ALPHA)
      end do
      nterms=5
cccccccccccccccccccccccccccccccccccccccccccccccccc

      a0alpha=CBESS(0)
      a1alpha=2.0D0*CBESS(1)
c.....Renorm the Hamiltonian which is eq(4.2) in Kosloff1991.
      call che_renorm(v,np,vnorm,1.d0/ESC,-E0/ESC)
c      print *,1.d0/ESC
c      print *,-E0/ESC
c      print *, vnorm(1,1)
c      print *, vnorm(2,1)
c      print *, vnorm(1,2)
c      print *, vnorm(2,2)
c.....Convert to complex matrix vc
      call rmtocm(vnorm,np,vc)
c.
c     check vc
c.      do i=1,np
c         do k=1,np
c            trynum=-EYE*DCMPLX(ESC,0.D0)*vc(i,k)
c            print *,'the A matrix is',i,k,trynum
c         end do
c      end do
c
ccccccccccccccccccccc INITILIZATION cccccccccccccccccccccccccccccc
cccccc Initilize values of Chebyshev polynomial phir and phic ccccccc
c.....
c.....phir (retard) is phi_n-1 in Kosloff1991,initially it is psi(0).
c.....       In the end of the iteration, it is substituted by phinm1.
c.....phic (current) is phi_n in Kosloff,initially it is -i*vc*psi(0).
c.....       In the end of the iteration, it is substituted by phi_n.
c.      phir=psii
c.....Multiply matrix vc with vector psii.
c     The reslut vector is stored in temv=vc*psii
      call cmmulv(vc,psii,np,temv)
cccccccccccccc   Initiliza values of phir/psif (wavefunction) cccccccccccc
c.....Intially: psif=a0alpha*phir+a1alpha*phic
c.....               =a0alpha*psii+a1alpha*(-EYE)*vc*psii.
c.....               =
c.....Implement Chebychev recursion formula. Eq(4.5) in Kosloff
c.....phif (forward) is phi_n+1 in Kosloff.
c.....psif (final) is the wavefunction at the end of the propagation.
c.....It is Eq(4.3) in Kosloff. Will add the phase factor later.
      do j=1,np
         phir(j)=psii(j)
         phic(j)=-EYE*temv(j)
         psif(j)=a0alpha*phir(j)+a1alpha*phic(j)
c         psif(j)=DCMPLX(a0alpha,0.D0)*phir(j)+
c     *    DCMPLX(a1alpha,0.D0)*phic(j)
      end do
c.....
c.....Loop starts from n=2 order of Chebyshev till n=neterms order.
c.....phi_n+1=-2*EYE*H_norm*phi_n+phi_n-1 in Kosloff1991
c.....it is phif=-2*EYE*vc*phic+phir in our notations
      do i=2,nterms
c.....aalpha is related to the i-th bessel function
         aalpha=2.0d0*CBESS(i)
c.....temv=vc*phic is the resultant vector of H_norm*phi_n in Kosloff
         call cmmulv(vc,phic,np,temv1)
c.....j is vector index
         do j=1,np
            phif(j)=-2.0D0*EYE*temv1(j)+phir(j)
c            phif(j)=DCMPLX(0.d0,-2.0D0)*temv1(j)+phir(j)
c.....final wavefunction
            psif(j)=psif(j)+aalpha*phif(j)
c            psif(j)=psif(j)+DCMPLX(aalpha,0.D0)*phif(j)
            phir(j)=phic(j)
            phic(j)=phif(j)
         end do
      end do
c overwrite initial psi with final psi to interate
      do j=1,np
         psifstore(j)=CPF*dreal(psif(j))
         psifstore(j+np)=CPF*dimag(psif(j))
         psii(j)=CPF*psif(j)
      end do
c overwrite initial psi with final psi to interate
c
c      print *,nterms
c      print *,psifstore(1)
c      print *,psifstore(3)


      return
      end
