cccccccccccccccccccccccccccccccccccccccccccccccccc
c     expmmv Directly exponential
cccccccccccccccccccccccccccccccccccccccccccccccccc
c     This uses exponential method for real symmetric matrix
c.    see http://www.nag.com/numeric/fl/manual19/pdf/F02/f02faf_fl19.pdf
c.        Phi(t+deltat)=exp[-i*H(t)*deltat]*Phi(t)
c.                     =eigv*exp[-i*d(t)*deltat}*eigv^T*Phi(t)
c.        eigv is an orthogonal matrix, whose columns are
c.        the eigenvectors. d(t) is the eigenvalues of H(t).
c     Also see Frapiccini et. al. PRA 89, 023418 (2014)
c     but for no kinetic energy term
cccccccccccccccccccccccccccccccccccccccccccccccccc
c     HY 22 July 2015
c
cccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine expmmv(v,cpsii,np,deltatime,psifstore)
ccccccccccccccccccccc  INPUT cccccccccccccccccccc
c.    1) v = np*np real symmetic double precision potential matrix at time t
c.    2) cpsii = initial wavefunction Phi(t), complex*16 np array
c.    3) np  = size of state basis (same as n)
c     4) deltatime = time interval dt for exponential
ccccccccccccccccccccc  OUTPUT cccccccccccccccccccc
c     1) v returns a matrix where elements of input v above the
c     diagonal are destroyed.
c     2) on output, cpsii is the final wavefunction at t+dt
c     3) psifstore = final state amplitudes, complex, first np is real, second np is imaginary
ccccccccccccccccccccccccccccccccccccccccccccccccccc
      integer i, j, k, np, n, m
c      double precision a(np,np),b(2*np),c(np,np)
      double precision deltatime
      double precision v(np,np),D(np),eigv(np,np),psifstore(2*np)
      complex*16 inter,phase,cpsii(np),cv(np,np),cpsi(np)
      external JACOBI1
c      double precision v(np,np),psif(2*np),psifstore(2*np)
c      double precision d,deltatime,time,probtotal
c      dimension indx(2*np)
c


      call JACOBI1(v,np,np,D,eigv,m)

      do i=1,np
c         print *,D(i)
         do j=1,np
            cv(i,j)=dcmplx(eigv(i,j),0.0d0)
c            print *,cv(i,j)
         end do
      end do


      do i=1,np
         inter=DCMPLX(0.0d0,0.0d0)
         do j=1,np
            inter=inter+cv(j,i)*cpsii(j)
c            print *, cpsii(j),cv(j,i)
         end do
c         print *,inter
c         cpsii(i)=inter
c         print *,deltatime
         phase=dcmplx(0.0d0,-1.0d0*D(i)*deltatime)
c         print *,phase
ccccccccccccccccccc Bug here! cpsii value change here cccccccccc
c         cpsii(i)=cdexp(phase)*inter
cccccccccccccccccccccccccccccccccccccccccccccc
          cpsi(i)=cdexp(phase)*inter
c         print *,cpsii(i)
      end do

      do i=1,np
         inter=DCMPLX(0.0d0,0.0d0)
         do j=1,np
c            inter=inter+cv(i,j)*cpsii(j)
             inter=inter+cv(i,j)*cpsi(j)
         end do
c         print *,inter
         cpsii(i)=inter
         psifstore(i)=dreal(inter)
         psifstore(i+np)=dimag(inter)
      end do



      return      
      end

