cccccccccccccccccccccccccccccccccccccccccccccccccc
c cn_prop_noke1 Crank-Nickolson
cccccccccccccccccccccccccccccccccccccccccccccccccc
c uses Crank-Nickolson fully implicit method
c but for no kinetic energy term
cccccccccccccccccccccccccccccccccccccccccccccccccc
c PCS 07 June 2012
c
c
c
c
cccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine cn_prop_noke1(v,psii,np,indx,deltatime,psifstore)
      integer i, j, k, indx, np, n,nt,npt
      double precision a(np,np),b(2*np),c(np,np)
      double precision psii(2*np),xi(2*np),ac(2*np,2*np)
      double precision v(np,np),psif(2*np),psifstore(2*np)
      double precision d,deltatime,time,probtotal
      dimension indx(2*np)
c
c v is the Hamiltonian operator in which is the potential energy operator
c psii is the initial state which contains the real and imaginary parts
c np is the dimension of the Hamiltonian, which is the # of the channels
c
      npt=2*np
      nt=2*np
c
c fill arrays
c a is identity or real part of CN propagator
c c is imaginary part for real v
      do i=1,np
         do j=1,np
           c(i,j)= 0.5d0*v(i,j)*deltatime
           if(i.eq.j) then
                a(i,j)=1.0d0
           else
                a(i,j)=0.0d0
           end if
         end do
      end do
c fill complex ac matrix, aka Press
      do i=1,2*np
        do j=1,2*np
           if ((i.le.np).and.(j.le.np)) then
              ac(i,j)=a(i,j) 
           else if ((i.le.np).and.(j.gt.np)) then
              ac(i,j)=-1.d0*c(i,j-np)
           else if ((i.gt.np).and.(j.le.np)) then
              ac(i,j)=c(i-np,j)
           else
              ac(i,j)=a(i-np,j-np)
           end if
         end do
c         write(10,*) (ac(i,j), j=1,2*np) 
       end do
c do ludcmp once for the same a, but different b 
      call ludcmp(ac,nt,npt,indx,d)
c
c      do j=1,nstep
         do i=1,2*np
            b(i)=2.0d0*psii(i)
         end do
c
      call lubksb(ac,nt,npt,indx,b)
c
c evaluate final psi
c
      do i=1,2*np
         psif(i)=b(i)-psii(i)
c         write(11,*) i,psii(i),b(i),psif(i)
c
c overwrite initial psi with final psi to interate
c
         psii(i)=psif(i)
      end do
      do i=1,2*np
         psifstore(i)=psif(i)
      end do
c      end do
c
      return      
      end

