ccccccccccccccccccccccccccccccccccccccccccccccccc
c potn 
ccccccccccccccccccccccccccccccccccccccccccccccccc
c subroutine to read n x n dimensional potential
c matrix, assuming the matrix is real and 
c symmetric and spline fit it
ccccccccccccccccccccccccccccccccccccccccccccccccc
c PCS 20 May 2015
c     modified to read any diabatic potential matrix
c
c PCS 11 June 2012
c     modified to read 3-channel Na-He data, but
c     generate n-channel approximate data.
c
c PCS 14 Jan 2013
c  some documentation added
c  nc = number of coupling (off-diagonal) elements of data
c      to be read
c  nd = number of diagonal terms with actual data, here 3
c  n = total number of channels, here can be 1 to 200
c  r = array of internuclear distance points (data)
c  pot = entire final potential array
c  pot2 = spline parameters for potential -> returned from subroutine
cccccccccccccccccccccccccccccccccccccccccccccc
c  Files:
c     input: potential matrix, here unit=18,19,20,
c            modify as needed
cccccccccccccccccccccccccccccccccccccccccccccccccc
      subroutine potn (n,r,pot,pot2,ndat,nd,eshift)
c
      integer i,j,k,kk,n,ndat,nd,ne,jj,jk,ki
      parameter(ne=200)
      double precision r(ndat),pot(ndat,n,n)
      double precision pot1(n,n),potend(n,n),pott(ndat)
      double precision pot2(ndat,n,n),pott2(ndat)
      double precision pottmp(n**2),eshift
      character junk*20
      external spline
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c read potential data and fill potential arrary
c
      open(unit=18, file ='si3+he_5chn.dat')
ccccc
c read and discard header
      do i=1,8
         read(18,*) junk
      end do
c read in potential matrix data. First diagonal terms, then
c upper triangle for off-diagonal terms
      do i=1,ndat
         ki=n+1
	 read (18,*) r(i), (pottmp(j), j=1,n*(n+1)/2)
         do j=1,nd
            pot(i,j,j)=pottmp(j)-eshift
            do k=j+1,nd
               pot(i,j,k)=pottmp(ki)
               pot(i,k,j)=pot(i,j,k)
               ki=ki+1
            end do
         end do
c         write(21,*) r(i), (pot(i,j,j), j=1,n)
c         write(29,*) r(i),pot(i,1,2),pot(i,2,1),pot(i,1,3),pot(i,3,1),
c     .              pot(i,2,3),pot(i,3,2)
c         write(39,*) r(i),pot(i,1,4),pot(i,4,1),pot(i,2,4),pot(i,4,2),
c     .              pot(i,3,4),pot(i,4,3)
c         write(49,*) r(i),pot(i,1,5),pot(i,2,5),pot(i,3,5),
c     .              pot(i,4,5),pot(i,5,4)
      end do      
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c spline fit all potential terms
c
c determine first and last point derivatives
      do j=1,n
        do k=1,n
           pot1(j,k)=(pot(2,j,k)-pot(1,j,k))/(r(2)-r(1))
           potend(j,k)=(pot(ndat,j,k)-pot(ndat-1,j,k))
     .            /(r(ndat)-r(ndat-1))
c        write(21,*) j,k,pot1(j,k),potend(j,k)
        end do
      end do
c !!!!! add long-range forms later
c
c determine spline coefficients
c
      do j=1,n
         do k=j,n
           do i=1,ndat
              pott(i)=pot(i,j,k)
           end do
           call spline(r,pott,ndat,pot1(j,k),potend(j,k),pott2)
           do  i=1,ndat
              pot2(i,j,k)=pott2(i)
              pot2(i,k,j)=pott2(i)
           end do
        end do
      end do
10      return
c pot(i,j,k), pot2(i,j,k) contains the spline parameters at node i for 
c potential element  j,k
c
      end

