cccccccccccccccccccccccccccccccccccccccccccccccccc
c sccn :preconditioned adaptive Fehlberg- Runge- Kutta method
c author: Hao You, haoyou@physast.uga.edu
c version: 0.1
c date: 01-30-2016
cccccccccccccccccccccccccccccccccccccccccccccccccc
c time-dependent code to compute multistate 
c probabilities (and amplitudes) without a kinetic
c energy term (potential only)
c
c uses  preconditioned adaptive Fehlberg- Runge- Kutta method.
c potential is read in through potn
cccccccccccccccccccccccccccccccccccccccccccccccccc
c 1)    modified to treat any n-channel problem in which
c     coupling terms do not need modifying (i.e., as
c     for the case of rotational coupling). This version
c     comes with Si^3+/He as an example.
c 2)    modified to loop over impact parameter
c     and centrifugal potential added.
c.
c Required changes to run code
c 1. update parameter values for particular problem
c 2. Input potential energy matrix read in potn.f - edit
c    file name
c 3. Update matrix zero-out in data statements
c
c Files:
c 1. input.dat - all control paramaters
c 2. *.dat - to contain potential matrix, read by potn.f
ccccccccccccccccccccccccccccccccccccccccccccccccccc
cccc data in parameter statements *** need editing
c np = number of channels (rank of potential matrix)
c n  = size of state basis (same as np)
c nstep = number of time steps in integration (here constant step)
c ndat = length of potential data for each matrix element (different time)
c nchn = size of matrix array in data 
c time0 =  starting time (a.u)  at large asymptotic distance
c          (value chosen here to remain within potential data)
c b0 = starting impact parameter (a.u.)
c b = impact parameter (a.u.)
c v0 = initial velocity (a.u.)
c dt = time step (a.u.)
c mu = collision system reduced mass
c
cccc other parameters
c ioff = number of off-diagonal terms in upper half of potential matrix
c psii = initial state amplitudes, complex, first np is real, second np is imaginary
c initial = initial state index
c etime, elapsed, total, proptime, intime, outime - parameters used for
c    tracking compute times
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      integer i, j, k, ii, jj, kk, indx, np, n, nt, nstep, ndat,nchn
      integer ic,ioff,bnum,initial
      integer nok nbad
c**** edit as needed
      parameter(np=5,n=5,ndat=47,nchn=5,ipistate=0)
      double precision time0,b0,v0,b,mu,mau,uau,bmax,eps,h1,hmin
      double precision vtmp(np*np/2)
      double precision psii(2*n)
      double precision v(np,np),psif(2*n),prob(n)
      double precision vh(np,np),vf(np,np)
      double precision d,dt,time,probtotal
      double precision psifstore(2*np),psi0r,psi0i
      double precision r(ndat),pot(ndat,np,np),pot2(ndat,np,np)
      double precision pott(ndat),pott2(ndat),x,y
c**** edit as needed
c.    Stepsize definitions:
c.    h1 - initial guess; hmin - minimum stepsize
c.    eps - allowable error for the adaptive size method.
      parameter(h1=1.0d-1,hmin = 1.0d-2,eps = 1.0d-4)
      real etime, elapsed(2), total, proptime,intime,outtime
      COMPLEX*16 cpsii(np),ystart(np),dpsidt(np)
      complex*16 va(n,n),vha(n,n),vfa(n,n)
c constants and conversion parameters
c     converts mass in u to atomic units
      parameter (uau=1822.88732d0)
      dimension indx(2*n)
c      external potn,cn_prop_noke,splint,chebyshev3,VrtoVc,pomt
      external potn,pomt,splint,VrtoVc
      external derivs,rkqs
c
c******* must be 2*number of channels, real and imaginary 
      data psii /10*0.0d0/
      data psifstore /10*0.0d0/
      data prob /5*0.0d0/
c
c read input parameters
      open(unit=30,file="input.dat",status="old")
c
      read(30,*) v0, b0, bmax, bnum
      read(30,*) mu, rstart, dt
c
c  since only one state is populated initially
cpcs *****hack, now set at ground state, generalize later
      read(30,*) initial 
      read(30,*) psii(initial),psii(initial+np)
      psi0r=psii(initial)
      psi0i=psii(initial+np)
c
c determine constants, run time, number of steps
      mau=mu*uau
c.    time0: initial time and final time is -time0
      time0=-dsqrt(rstart**2-b0**2)/v0
c.      nstep=dint(-2*time0/dt)
      write(80,*) mau,time0

c determine number of off-diagonal terms in the matrix
      ioff=(np-1)*np/2
c call and set-up potential spline
      call potn(n,r,pot,pot2,ndat,nchn)
c
c time counter for reading and constructing potential matrix
c
      total=etime(elapsed)
c      write(80,*)'input'
c      write(80,*) total,elapsed(1),elapsed(2)
      intime=elapsed(1)
c
c loop over impact parameter
      do ii=1,bnum
c
c clear wave functions and probs for each impact parameter
       do ij=1,np
          psii(ij)=0.0d0
          psii(ij+np)=0.0d0
          psifstore(ij)=0.0d0
          psifstore(ij+np)=0.0d0
          prob(ij)=0.0d0
       end do
c populate initial state wave function
       psii(initial)=psi0r
       psii(initial+np)=psi0i
       call VrtoVc(psii,np,cpsii)
c       print*,psii(1),psii(1+np),cpsii(1)
c calculate impact parameter grid
         time=time0
         if(b0.le.1.0d0) then
            b=b0+b0*dfloat(ii-1)*0.1d0
         else if(b0.gt.1.0d0) then
            b=b0+b0*dfloat(ii-1)*1.0d0
         end if
c ending criteria
         if(b.gt.bmax) goto 998
         if(time.gt.dabs(time0)) goto 998
c
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
c.    call odeint to do adaptive control
c.    Integration boundaries and initial values:
c	      x1 = time0
c	      x2 = -time0
c	      ystart = 1.0d0
c.    Stepsize definitions:
c.    (h1 - initial guess; hmin - minimum stepsize)
c.          h1 = 1.0d-1
c.          hmin = 1.0d-2
c          write(1,*)'(Initial) Stepsize:',h1
c.    Allowable error for the adaptive size method:
c.	      eps = 1.0d-4
c          eps=2.0d-4
c.    Calculations:
c.    Adaptive Size Method:
c	      y = ystart
          ystart=cpsii
c.	      call odeint(y,nvar,x1,x2,eps,h1,hmin,nok,nbad,derivs,rkqs)
          call odeint(ystart,np,time0,-time0,eps,h1,hmin,nok,nbad,
     *     derivs,rkqs,r,pot,pot2,ndat,mau,b,v0)
c
c****  start loop over time steps for given b
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC







c check some diagaonal potentials
c         if(time.eq.0.0d0)
c     .    write(80,997)  x, (v(i,i),i=1,np)
c write out probabilities at certain b
c         if(b.eq.1.0d0)
c     .    write(11,*) time, (prob(i), i=1,np), probtotal
c         print *,(prob(i), i=1,np)

c clear total and ij probabilities at each time step
         probtotal=0.0d0
         do i=1,np
            prob(i)=0.0d0
         end do
         do i=1,np
            psifstore(i)=dreal(ystart(i))
            psifstore(i+np)=dimag(ystart(i))
         end do
         do i=1,np
            prob(i)=psifstore(i)**2+psifstore(i+np)**2
            probtotal=probtotal + prob(i)
c            write(10,*) i,prob(i),probtotal
         end do
c
c timing info
      total=etime(elapsed)
c      write(80,*) "propagator time"
c      write(80,*) total,elapsed(1),elapsed(2)
      proptime=elapsed(1)-intime
         write(10,*) v0, time, b, (prob(i), i=1,np), probtotal
c          write(20,*) v0, time, b, (prob(i), i=1,np), probtotal
c         print *,(prob(i), i=1,np)
c
10    continue
      total=etime(elapsed)
c      write(80,*) "print time"
c      write(80,*) total,elapsed(1),elapsed(2)
      outtime=elapsed(1)-proptime
      totaltime=intime+proptime+outtime
      write(80,*) totaltime,intime,proptime,outtime
c
c end loop on impact parameter
      end do

998    continue
997    format('t=0',11e16.6)
999    format(30e16.6)
      stop
      end

