      subroutine rkqs(y,dydx,n,x,htry,eps,yscal,hdid,hnext,derivs,r,
     * pot,pot2,ndat,mau,b,v0)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c.    Fifth-order Runge-Kutta step with monitoring of local truncation
c.    error to ensure accuracy and adjust stepsize.
c.    Input are the dependent variable vector y(1:n) and
c.    its derivative dydx(1:n) at the starting value of the independent
c.    variable x. Also input are the stepsize to be attempted htry,
c.    the required accuracy eps (i.e.,delta_0), and the vector yscal(1:n)
c.    against which the error is scaled.
c.    On output, y and x are replaced by their new values,
c.    hdid is the stepsize that was actually accomplished,
c.    and hnext is the estimated next stepsize.
c.    derivs is the user-supplied subroutine that computes
c.    the right-hand side derivatives.
	  implicit none
c.	  integer n,i,NMAX
      integer n,i,ndat
	  double precision eps,hdid,hnext,htry,x
	  complex*16 dydx(n),y(n),yscal(n)
	  external derivs,rkck
	  double precision r(ndat),pot(ndat,n,n),pot2(ndat,n,n),mau,b,v0
c.    Maximum number of euqations.
c.	  parameter(NMAX=50)
c.	  double precision errmax,h,htemp,xnew,yerr(NMAX),ytemp(NMAX)
	  double precision errmax,h,htemp,xnew
	  complex*16 yerr(N),ytemp(N)
	  double precision SAFETY,PGROW,PSHRNK,ERRCON
	  parameter(SAFETY=0.9d0,PGROW=-0.2d0,PSHRNK=-0.25d0)
	  parameter(ERRCON=1.89d-4)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

c.    step size to the initial trial
	  h=htry
c.    yerr is the estimated absolute error in eq(16.2.6)
1	  call rkck(y,dydx,n,x,h,ytemp,yerr,derivs,r,pot,pot2,ndat,
     * mau,b,v0)
c.      print *, 'In rkqs, yerr is',yerr(1),yerr(2),yerr(3)
c.      print *, 'In rkqs, yscal is',yscal(1),yscal(2),yscal(3)
c.    evaluate accuracy.
      errmax=0.0d0
c.    errmax is the estimated fraction error which is delta_0/yscal(i)
c.    in eq(16.2.8),actually should be delta_1 in eq(16.2.10)
ccccccccccccccccccccccccccccccccccccccccccccc
c.    There was a bug here in numerical recipes
	  do 11 i=1,n
	     if (cdabs(yerr(i)/yscal(i)).lt.1) then
	         errmax=max(errmax,cdabs(yerr(i)/yscal(i)))
	     else
	         errmax=errmax
	     end if
c.	     print *, 'In rkqs, errmax is',errmax
11	  continue
*      print *, 'In rkqs, max error is',errmax
c.    Now compare the estimated fraction error eps_1=errmax rhs with
c.    the desired (required) fraction error eps_0.
c.    It equals to delta_1/delta_0. Scale relative to required tolerance.
	  errmax=errmax/eps

c.    Case 1: Truncation error too large, reduce stepsize.
	  if(errmax.gt.1.0d0) then
	     htemp=SAFETY*h*(errmax**PSHRNK)
c.    No more than a factor of 10.
	     h=sign(max(dabs(htemp),0.1d0*dabs(h)),h)
c.	     print *, 'in rkqs',h,x,x+h
	     xnew=x+h
	     if(xnew.eq.x) pause 'stepsize underflow in rkqs'
c.    Trial failure with htry intially, do another try using the new
c.    reduced h.
	     goto 1
c.    Case 2: Step succeeded. Compute size of next step
	  else
	     if(errmax.gt.ERRCON) then
	       hnext=SAFETY*h*(errmax**PGROW)
	     else
	       hnext=5.0d0*h
	     endif
	     hdid=h
	     x=x+h
	     do 12 i=1,n
	        y(i)=ytemp(i)
12	     continue
	     return
	  endif

	  end
