      SUBROUTINE rkck(y,dydx,n,x,h,yout,yerr,derivs,r,pot,pot2,ndat,
     * mau,b,v0)
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     Given values for n variables y and their derivatives dydx known
c.    at x, use the fifth-order Cash-Karp Runge-Kutta method to
c.    advance the solution over an interval h and return the
c.    incremented variables as yout.
c.    Also return an estimate of the local truncation error in
c.    yout using the embedded fourth-order method.
c.    The user supplies the subroutine derivs(x,y,dydx),
c.    which returns derivatives dydx at x.
c.    From numerical recipt.
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c     input parameters
c     y: wavefunction in our case.
c     dydx: derivative of the wavefunction with respect to time.
c     n: dimension of the wavefunction
c     x:time
c     h:time interval
c     derivs:subroutine which returns derivatives dydx at x
c     r,pot,pot2:input data from subroutine
c     ndat
c     mau
c     b
c     v0
c     output parameters
c     yout:wavefunction at time x+h
c     yerr:local truncation error in y

      implicit none
c      INTEGER n,NMAX
      integer n,ndat
      double precision h,x
      complex*16 dydx(n),y(n),yerr(n),yout(n)
      EXTERNAL derivs
c.      PARAMETER (NMAX=50)
c     USES derivs:
      INTEGER i
c.      double precision ak2(NMAX),ak3(NMAX),ak4(NMAX),ak5(NMAX),ak6(NMAX)
c.      double precision ytemp(NMAX),
      complex*16 ak2(n),ak3(n),ak4(N),ak5(N),ak6(N),ytemp(n)
      double precision r(ndat),pot(ndat,n,n),pot2(ndat,n,n),mau,b,v0
      double precision A2,A3,A4,A5,A6,B21,B31,B32,B41,B42,B43
      double precision B51,B52,B53,B54,B61,B62,B63,B64,B65
      double precision C1,C3,C4,C6,DC1,DC3,DC4,DC5,DC6
      PARAMETER (A2=.2d0,A3=.3d0,A4=.6d0,A5=1.0d0,A6=.875d0)
      parameter (B21=.2d0,B31=3.0d0/40.0d0, B32=9.0d0/40.0d0)
      parameter (B41=0.3d0,B42=-0.9d0,B43=1.2d0)
      parameter (B51=-11.0d0/54.0d0,B52=2.5d0, B53=-70.0d0/27.0d0)
      parameter (B54=35.0d0/27.0d0,B61=1631.0d0/55296.0d0)
      parameter (B62=175.0d0/512.0d0,B63=575.0d0/13824.0d0)
      parameter (B64=44275.0d0/110592.0d0,B65=253.0d0/4096.0d0)
      parameter (C1=37.0d0/378.0d0, C3=250.0d0/621.0d0)
      parameter (C4=125.0d0/594.0d0,C6=512.0d0/1771.0d0)
      parameter (DC1=C1-2825.0d0/27648.0d0, DC3=C3-18575.0d0/48384.0d0)
      parameter (DC4=C4-13525.0d0/55296.0d0,DC5=-277.0d0/14336.0d0)
      parameter (DC6=C6-0.25d0)

c.    First step
      do 11 i=1,n
        ytemp(i)=y(i)+B21*h*dydx(i)
11    continue
c.    Second step
        call derivs(x+A2*h,ytemp,r,pot,pot2,ndat,mau,n,b,v0,ak2)
c.      call derivs(x+A2*h,ytemp,ak2)
      do 12 i=1,n
        ytemp(i)=y(i)+h*(B31*dydx(i)+B32*ak2(i))
12    continue
c.    Third step
c      call derivs(x+A3*h,ytemp,ak3)
      call derivs(x+A3*h,ytemp,r,pot,pot2,ndat,mau,n,b,v0,ak3)
      do 13 i=1,n
        ytemp(i)=y(i)+h*(B41*dydx(i)+B42*ak2(i)+B43*ak3(i))
13    continue
c.    Fourth step
c.      call derivs(x+A4*h,ytemp,ak4)
      call derivs(x+A4*h,ytemp,r,pot,pot2,ndat,mau,n,b,v0,ak4)
      do 14 i=1,n
        ytemp(i)=y(i)+h*(B51*dydx(i)+B52*ak2(i)+B53*ak3(i)+B54*ak4(i))
14    continue
c.    Fifth step
c      call derivs(x+A5*h,ytemp,ak5)
      call derivs(x+A5*h,ytemp,r,pot,pot2,ndat,mau,n,b,v0,ak5)
      do 15 i=1,n
        ytemp(i)=y(i)+h*(B61*dydx(i)+B62*ak2(i)+B63*ak3(i)+B64*ak4(i)+
     *B65*ak5(i))
15    continue
c.    Sixth step
c      call derivs(x+A6*h,ytemp,ak6)
      call derivs(x+A6*h,ytemp,r,pot,pot2,ndat,mau,n,b,v0,ak6)
      do 16 i=1,n
        yout(i)=y(i)+h*(C1*dydx(i)+C3*ak3(i)+C4*ak4(i)+C6*ak6(i))
16    continue
c.    Estimate error as difference bw fourth and fifth order methods
      do 17 i=1,n
        yerr(i)=h*(DC1*dydx(i)+DC3*ak3(i)+DC4*ak4(i)+DC5*ak5(i)+DC6*
     *ak6(i))
17    continue
      return
      END
