      subroutine preCA1(v,va,n)
c.    Convert the n*n real symmentric potential matrix v at time t into
c.    a preconditioned n*n complex A.
c.       where A is defiend as A=-iv/hbar in Tremblay 2004.
c.    The precondition uses the simple eigenvalue estimation.
c.    Paper link:
c.    http://scitation.aip.org/content/aip/journal/jcp/121/23/10.1063/1.1814103
ccccccccccccccccccccc  INPUT cccccccccccccccccccc
c.    1) v: real symmentric potential matrix v at time t (from pomt)
c.    2) n: dimmension of v
ccccccccccccccccccccc  OUTPUT cccccccccccccccccccc
c     1) va is the n*n complex A matirx
cccccccccccccccccccccccccccccccccccccccccccccccccc
          implicit none
          integer n,m,i,j
          double precision vmax,vmin, deltaVh
          double precision v(n,n),inter(n,n)
c          double precision D(n),eigv(n,n)
          complex*16 EYE
          complex*16 va(n,n)
c          external JACOBI1,eigsrt
ccccccccccccccccccccccccccccccccccccccccccccccccccccc
c          inter=v
c          call JACOBI1(inter,n,n,D,eigv,m)
c          call eigsrt(D,eigv,n,n)
          vmax=v(1,1)
          vmin=v(1,1)
          do i=2,n
             if (v(i,i).ge.vmax)then
                vmax=v(i,i)
             else if (v(i,i).lt.vmin)then
                vmin=v(i,i)
             endif
          end do
c          vmax=D(1)
c          vmin=D(n)
          deltaVh=(vmax-vmin)/2.0d0
c.          print *, 'eigenvalue is', vmax,vmin
c.....EYE is double complex number i
          EYE=DCMPLX(0.D0,1.D0)
          do i=1,n
             do j=1,n
                if (i.eq.j) then
                   va(i,j)=-EYE*DCMPLX(v(i,j)-vmin-deltaVh,0.0d0)
                else
                   va(i,j)=-EYE*DCMPLX(v(i,j),0.0d0)
                end if
c.                print *, 'the Hamiltonian is',i,j,va(i,j)
             end do
          end do
c      print *, 'va is', va(1,1),va(1,2),va(2,1)

          return
      end
