      subroutine odeint(ystart,nvar,x1,x2,eps,h1,hmin,nok,nbad,derivs,
     * rkqs,r,pot,pot2,ndat,mau,b,v0)

c     Runge-Kutta driver with adaptive stepsize control
c      from Numerical Recipes
c     nvar: number of equations
c     x1, x2: initial and final values of indep variable
c     ystart: initial values
c     eps: desired accuracy
c     path: common block stores intermediate results
c     h1: initial step size (guess)
c     hmin: minimum allowed step size (can be zero)
c     nok, nbad: number of good and bad (retried) steps
c.    Reference:
c.    http://www.fisica.ufmg.br/~dickman/transfers/comp/odeint.f
c.    http://www.astro.cornell.edu/~akgun/Fortran/Numerique/adaptive.f



		implicit none
		integer nbad,nok,nvar,KMAXX,MAXSTP
		integer ndat
c.		integer nbad,nok,nvar,KMAXX,MAXSTP,NMAX
		double precision eps,h1,hmin,x1,x2,TINY
		double precision dxsav,h,hdid,hnext,x,xsav
		complex*16 ystart(nvar),y(nvar),yscal(nvar),dydx(nvar)
		double precision r(ndat),pot(ndat,nvar,nvar)
		double precision pot2(ndat,nvar,nvar),mau,b,v0
		external derivs,rkqs
c.		parameter(MAXSTP=10000,NMAX=50,KMAXX=200,TINY=1.0d-30)
		parameter(MAXSTP=10000,TINY=1.0d-30)
c. tiny=1.0d-30 is too small
c.    Parameter nyp change!
c		parameter(nyp=1)
c		integer i,kmax,kount,nstp
        integer i,nstp
c.		double precision dxsav,h,hdid,hnext,x,xsav,dydx(NMAX)
c.		double precision xp(KMAXX),y(NMAX),yp(NMAX,KMAXX),yscal(NMAX)
c.        double precision xp(KMAXX),y(nvar),yscal(nvar),yp(nvar,KMAXX)
c        double precision xp(KMAXX),yp(nyp,KMAXX)


c		common /path/ kmax,kount,dxsav,xp,yp
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
c.    Initially x=x1, h=h1
		x=x1
		h=sign(h1,x2-x1)
c      The function sign in Fortran is called the sign transfer function.
c      It is a function of two variables, and its definition involves two cases:
c      CASE 1:   If y >= 0 then sign(x,y) = abs(x)
c      CASE 2:   If y < 0 then sign(x,y) = -abs(x)
       nok=0
	   nbad=0
	   do 11 i=1,nvar
		   y(i)=ystart(i)
11	    continue

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C		nok=0
C		nbad=0
c		kount=0

c     preset dxsav and kmax
c.    kmax: number of steps that can be stored
c.    dxsav: minimum interval with which the intermediate resluts stored.
c		kmax= 50
c        dxsav = 0.01d0

c		do 11 i=1,nvar
c		   y(i)=ystart(i)
c 11	    continue

c.    Assure storage of 1st step
c      if (kmax.gt.0) xsav=x-2.0d0*dxsav
c.    Take at most MAXSTP steps
	  do 16 nstp=1,MAXSTP
c		   call derivs(x,y,dydx)
           call derivs(x,y,r,pot,pot2,ndat,mau,nvar,b,v0,dydx)
c           print *, 'in odeint, nstp is', nstp, dydx(1)
		   do 12 i=1,nvar
c.            Scaling used to monitor accuracy.
c.		   	     yscal(i)=dabs(y(i))+dabs(h*dydx(i))+TINY
               yscal(i)=cdabs(y(i))+cdabs(h*dydx(i))+TINY
12	   	   continue

c	       if(kmax.gt.0) then
c.    If two*dxsav>dxsav
c	          if(dabs(x-xsav).gt.dabs(dxsav)) then
c.    store intermediate results if kount < kmax-1
c	             if(kount.lt.kmax-1) then
c		            kount=kount+1
c		            xp(kount)=x
c		            do 13 i=1,nvar
c		               yp(i,kount)=y(i)
c 13		            continue
c.    update value of xsav
c		            xsav=x
c		         endif
c	          endif
c	   	   endif

c     If stepsize can overshoot, decrease
	   	   if((x+h-x2)*(x+h-x1).gt.0.d0) h=x2-x

c	       call rkqs(y,dydx,nvar,x,h,eps,yscal,hdid,hnext,derivs)
	       call rkqs(y,dydx,nvar,x,h,eps,yscal,hdid,hnext,derivs,r,
     * pot,pot2,ndat,mau,b,v0)
	       if(hdid.eq.h)then
	          nok=nok+1
	       else
	          nbad=nbad+1
	       endif

c     stop loop when x>=x2 and update ystart with the final value
	       if((x-x2)*(x2-x1).ge.0.d0)then
	           do 14 i=1,nvar
		          ystart(i)=y(i)
14	           continue
c	           if(kmax.ne.0)then
c		          kount=kount+1
c		          xp(kount)=x
c		          do 15 i=1,nvar
c		             yp(i,kount)=y(i)
c 15		          continue
c	           endif
	           return
	       endif
	       if(abs(hnext).lt.hmin) pause
     *	      'stepsize smaller than minimum in odeint'
	       h=hnext
16	  continue
	  pause 'too many steps in odeint'
	  return
	  end
