* Subroutine for the differential equation to be integrated.
* Calculates derivative dydx at point x for a function y.
* The potential matrix at point x is interpolated by pomt.

	  subroutine derivs(x,y,r,pot,pot2,ndat,mau,np,b,v0,dydx)
ccccccccccccccccccccccc Input cccccccccccccccccccccccccccccccccc
c.    1) x: variable which is time in Scrodinger Equation in our case
c.    2) y: function which is wave function
c.    3) r = array of internuclear distance points (data from potn)
c.    4) pot = entire potential array (from output of subroutine potn)
c.    5) pot2 = spline parameters for potential from output of potn)
c.    6) ndat = length of potential data for each matrix element
c.    7) mau = mu*uau: reduced mass (au) (given in main program sccf)
c.    8) np = number of channels (rank of potential matrix)
c.    9) b = impact parameter (a.u.)
c.    10) v0 = initial velocity (a.u.)
cccccccccccccccccccccc  Output cccccccccccccccccccccccccccccccccc
c.....dydx = A*psi = =(-iv/hbar)*psi in Tremblay 2004.
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
	  		implicit none
	  		integer ndat,np,i,j
	  		double precision x,mau,b,v0
	  		double precision r(ndat),pot(ndat,np,np),pot2(ndat,np,np)
	  		double precision v(np,np)
	  		complex*16 y(np),dydx(np)
	  		complex*16 va(np,np)
	  		external pomt,preCA1

c	  		dydx = dexp(x)
c.     construct potential matrix v at time x
      call pomt(b,v0,x,np,ndat,r,pot,pot2,mau,v)
c.      print *, b
c.     construct the preconditioned A matirx va
      call preCA1(v,va,np)
c.    Intiallization of dydx
      do i=1,np
         dydx(i)=DCMPLX(0.0d0,0.0d0)
      end do

      do i=1,np
         do j=1,np
c.             dyt(i)=dyt(i)+va(i,j)*y(i) This is wrong!
            dydx(i)=dydx(i)+va(i,j)*y(j)
         end do
      end do

	  		return
	  end
